PROC TABULATE DATA=ghpb13 MISSING NOSEPS;
CLASS contract_num_HEALTH INS3 ENT2 filingsize / PRELOADFMT;
VAR TPART;                                                                                                                                                                                                                                                                                                                                                                
title 'Table B3. Distribution of Group Health Plan Participants';
title2 'by type of insurance, type of plan, and number of health insurance contracts, 2013'; 
title3 'All Plans';
weight dup_wgt;
TABLE   (ALL='Total' contract_num_HEALTH=' ')*tpart=' '*sum=' '*f=k12f.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-' box='Number of Health Insurance Contracts';                                                                                                                                                                                                                                                                                                                                         
RUN;

PROC TABULATE DATA=ghpb13 MISSING NOSEPS;
where filingsize='1';
CLASS contract_num_HEALTH INS3 ENT2 filingsize / PRELOADFMT;
VAR TPART;                                                                                                                                                                                                                                                                                                                                                                
title 'Table B3. Distribution of Group Health Plan Participants';
title2 'by type of insurance, type of plan, and number of health insurance contracts, 2013'; 
title3 'Plans with 100 or More Participants & Trusts';
weight dup_wgt;
TABLE   (ALL='Total' contract_num_HEALTH=' ')*tpart=' '*sum=' '*f=k12f.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-' box='Number of Health Insurance Contracts';                                                                                                                                                                                                                                                                                                                                         
RUN;

PROC TABULATE DATA=ghpb13 MISSING NOSEPS;
where filingsize='2';
CLASS contract_num_HEALTH INS3 ENT2 filingsize / PRELOADFMT;
VAR TPART;                                                                                                                                                                                                                                                                                                                                                                
title 'Table B3. Distribution of Group Health Plan Participants';
title2 'by type of insurance, type of plan, and number of health insurance contracts, 2013'; 
title3 'Plans with 100 or More Participants & No Trusts';
weight dup_wgt;
TABLE   (ALL='Total' contract_num_HEALTH=' ')*tpart=' '*sum=' '*f=k12f.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-' box='Number of Health Insurance Contracts';                                                                                                                                                                                                                                                                                                                                         
RUN;

PROC TABULATE DATA=ghpb13 MISSING NOSEPS;
where filingsize='3';
CLASS contract_num_HEALTH INS3 ENT2 filingsize / PRELOADFMT;
VAR TPART;                                                                                                                                                                                                                                                                                                                                                                
title 'Table B3. Distribution of Group Health Plan Participants';
title2 'by type of insurance, type of plan, and number of health insurance contracts, 2013'; 
title3 'Plans with Fewer Than 100 Participants & Trusts';
weight dup_wgt;
TABLE   (ALL='Total' contract_num_HEALTH=' ')*tpart=' '*sum=' '*f=k12f.,                                                                                                                                                                                       
		(ALL='All Plans' INS3=' ')*(ALL='Total' ENT2=' ')/MISSTEXT='-' box='Number of Health Insurance Contracts';                                                                                                                                                                                                                                                                                                                                         
RUN;
